// components/printTest/printTest.js
Component({
  /**
   * 组件的属性列表
   */
  properties: {

  },

  /**
   * 组件的初始数据
   */
  data: {
    shiftY: 0

  },

  /**
   * 组件的方法列表
   */
  methods: {
    async printBarCodeHandler() {
      const sdk = getApp().globalData.sdk;
      await sdk.clearBuffer();
      await sdk.barcode(30, 30, "128", 100, 1, 0, 2, 2, "barcode1234");
      await sdk.printLabel(1, 1);
      console.log('printBarCodeHandler res=');
    },
    async printQRCodeHandler() {
      const sdk = getApp().globalData.sdk;
      await sdk.clearBuffer();
      await sdk.printQRcode({
        x: 10, y: 10, eccLevel: "H", cellWidth: 4, mode: "A", rotation: 0, content: "ABCabc123"
      });
      await sdk.printQRcode({
        x: 160, y: 160, eccLevel: "H", cellWidth: 4, mode: "A", rotation: 0, content: "123ABCabc"
      });
      // await sdk.printQRcode({
      //   x:310, y:310, eccLevel:"M", cellWidth:4, mode:"A", rotation:0,  model:"M2", content:"印表機ABCabc123" 
      // });
      await sdk.printLabel(1, 1);
      console.log('printQRCodeHandler done');
    },
    async printTextHandler() {
      const sdk = getApp().globalData.sdk;
      await sdk.clearBuffer();
      await sdk.printFont(190, 10, 3, 90, 1, 1, "Print Font 123456");
      // await sdk.printFont(
      //   250, 10, "TSS24.BF2", 90, 1, 1, "订单：47600326 物料：500023 数量：12面");
      // await sdk.printFont(
      //   110, 10, "TSS24.BF2", 90, 1, 1, "邱县公司运维检修部2022年配网低压维护维修材料购置费用");
      await sdk.printLabel(1, 1);
      console.log('printTextHandler done');
    },
    async printBlockHandler() {
      const sdk = getApp().globalData.sdk;
      await sdk.clearBuffer();
      await sdk.printBlock(15, 15, 400, 300, "0", 0, 8, 8, 20, 0, "We stand behind our products with one of the most comprehensive support programs in the Auto-ID industry.");
      await sdk.printLabel(1, 1);
      console.log('printBlockHandler done');
    },
    async formFeedHandler() {
      const sdk = getApp().globalData.sdk;
      await sdk.formFeed();
      console.log('sdk.formFeed() submited');
    },
    async printBMPHandler() {

      const res = await new Promise((resolve, reject) => {
        wx.chooseMessageFile({
          count: 1,
          type: "image",
          extension: ["BMP", "Bmp", "bmp"],
          success: resolve,
          fail: reject
        })
      });

      const filePath = res.tempFiles[0].path;
      const fileName = res.tempFiles[0].name;
      
      const readData = await new Promise((resolve, reject) => {
        wx.getFileSystemManager().readFile({
          filePath: filePath,
          success: resolve,
          fail: reject
        });
      });
      const fileData = new Uint8Array(readData.data);
      console.log('readData=',readData);

      //對裝置發送命令
      const sdk = getApp().globalData.sdk;
      await sdk.clearBuffer();
      await sdk.downloadBmp(fileData, fileName);
      await sdk.sendCommand(`PUTBMP 700,300,"${fileName}"`);
      await sdk.printLabel(1, 1);
      console.log('printBlockHandler done');

    },
    async printPCXHandler() {

      const res = await new Promise((resolve, reject) => {
        wx.chooseMessageFile({
          count: 1,
          type: "file",
          extension: ["PCX", "Pcx", "pcx"],
          success: resolve,
          fail: reject
        })
      });

      const filePath = res.tempFiles[0].path;
      const fileName = res.tempFiles[0].name;
      
      const readData = await new Promise((resolve, reject) => {
        wx.getFileSystemManager().readFile({
          filePath: filePath,
          success: resolve,
          fail: reject
        });
      });
      const fileData = new Uint8Array(readData.data);
      console.log('readData=',readData);

      //對裝置發送命令
      const sdk = getApp().globalData.sdk;
      await sdk.clearBuffer();
      await sdk.downloadPcx(fileData, fileName);
      await sdk.sendCommand(`PUTPCX 10,100,"${fileName}"`);
      await sdk.printLabel(1, 1);
      console.log('printBlockHandler done');

    },
    shiftYChangeHandler(e) {
      console.log(e.detail.value);
      this.setData({
        shiftY: e.detail.value
      });
    },
    async setFeedOffsetHandler() {
      const sdk = getApp().globalData.sdk;
      const shiftY= this.data.shiftY;
      await sdk.setShift(shiftY);
      await sdk.clearBuffer();
      await sdk.printFont(80, 40, "3", 0, 12, 12,
      `second page position shift ${shiftY} dot `);
      await sdk.printLabel(2, 1);
      console.log('setShift pattern submited');
    },
    async reverseHandler() {
      const sdk = getApp().globalData.sdk;
      await sdk.clearBuffer();
      await sdk.printFont(100, 100, "3", 0, 1, 1, "REVERSE");
      await sdk.printReverse(90, 90, 128, 40);
      await sdk.printLabel(1, 1);
      console.log('Reverse pattern submited');
    }

  }
})
